/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.mammal;

import com.github.alexthe666.citadel.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.IPackEntity;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ProjectileSpit;
import untamedwilds.entity.ai.GotoSleepGoal;
import untamedwilds.entity.ai.GrazeGoal;
import untamedwilds.entity.ai.SmartFollowOwnerGoal;
import untamedwilds.entity.ai.SmartLookAtGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartMeleeAttackGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.BeAnAssTarget;
import untamedwilds.entity.ai.target.ProtectChildrenTarget;
import untamedwilds.entity.ai.target.SmartOwnerHurtTargetGoal;
import untamedwilds.init.ModEntity;
import untamedwilds.util.EntityUtils;

public class EntityCamel
extends ComplexMobTerrestrial
implements INewSkins,
ISpecies,
IPackEntity {
    public static Animation IDLE_TALK;
    public static Animation ATTACK_SPIT;

    public EntityCamel(EntityType<? extends ComplexMob> type, Level worldIn) {
        super(type, worldIn);
        IDLE_TALK = Animation.create((int)20);
        ATTACK_SPIT = Animation.create((int)20);
        this.f_19793_ = 1.0f;
        this.turn_speed = 0.2f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new SmartMeleeAttackGoal((PathfinderMob)this, 1.6, false));
        this.f_21345_.m_25352_(3, (Goal)new SmartMateGoal(this, 0.8));
        this.f_21345_.m_25352_(3, (Goal)new GrazeGoal(this, 10));
        this.f_21345_.m_25352_(4, (Goal)new GotoSleepGoal(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new SmartWanderGoal(this, 1.0, 120, 0, true));
        this.f_21345_.m_25352_(6, (Goal)new SmartLookAtGoal(this, LivingEntity.class, 10.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new ProtectChildrenTarget<LivingEntity>(this, LivingEntity.class, true, input -> !(input instanceof EntityCamel) && EntityCamel.getEcoLevel(input) > EntityCamel.getEcoLevel((LivingEntity)this)));
        this.f_21346_.m_25352_(3, new BeAnAssTarget<LivingEntity>(this, LivingEntity.class, true, input -> !(input instanceof EntityCamel) && (EntityCamel.getEcoLevel(input) < EntityCamel.getEcoLevel((LivingEntity)this) / 2 || input instanceof Player)));
    }

    protected void m_5849_() {
        if (this.m_21824_()) {
            this.f_21345_.m_25352_(3, (Goal)new SmartFollowOwnerGoal(this, 1.3, 12.0f, 3.0f));
            this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
            this.f_21346_.m_25352_(2, (Goal)new SmartOwnerHurtTargetGoal(this));
        }
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22282_, 1.5).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    public boolean wantsToBreed() {
        if (((Boolean)ConfigGamerules.naturalBreeding.get()).booleanValue() && this.f_146733_ == 0) {
            return this.getHunger() >= 80;
        }
        return false;
    }

    @Override
    public void m_8107_() {
        if (!this.f_19853_.f_46443_) {
            int i;
            if (this.herd == null) {
                IPackEntity.initPack(this);
            } else {
                this.herd.tick();
            }
            if (this.f_19853_.m_46467_() % 1000L == 0L) {
                this.addHunger(-10);
                if (!this.isStarving()) {
                    this.m_5634_(1.0f);
                }
            }
            if ((i = this.f_19796_.nextInt(3000)) == 13 && !this.m_20069_() && this.m_5448_() == null && this.isNotMoving() && this.canMove() && this.getAnimation() == NO_ANIMATION) {
                this.setSitting(true);
            }
            if (i == 14 && this.isSitting()) {
                this.setSitting(false);
            }
            if (i > 2980 && !this.m_6162_()) {
                this.setAnimation(IDLE_TALK);
            }
            if (this.getAnimation() == IDLE_TALK && this.getAnimationTick() == 1 && this.m_7515_() != null) {
                this.m_5496_(this.m_7515_(), this.m_6121_(), this.m_6100_());
            }
        }
        super.m_8107_();
    }

    public boolean m_7327_(Entity entityIn) {
        boolean flag = super.m_7327_(entityIn);
        if (flag && this.getAnimation() == NO_ANIMATION && !this.m_6162_()) {
            Animation anim = this.chooseAttackAnimation();
            this.setAnimation(anim);
        }
        return flag;
    }

    @Override
    public boolean m_6469_(DamageSource p_19946_, float p_19947_) {
        if (p_19946_.equals(DamageSource.f_19314_)) {
            return false;
        }
        return super.m_6469_(p_19946_, p_19947_);
    }

    private Animation chooseAttackAnimation() {
        return NO_ANIMATION;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12361_, 0.15f, 1.0f);
    }

    @Nullable
    public EntityCamel getBreedOffspring(ServerLevel serverWorld, AgeableMob ageable) {
        return this.create_offspring(new EntityCamel((EntityType<? extends ComplexMob>)((EntityType)ModEntity.CAMEL.get()), this.f_19853_));
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (hand == InteractionHand.MAIN_HAND && !this.f_19853_.m_5776_() && !this.m_21824_() && this.m_6162_() && EntityUtils.hasFullHealth((LivingEntity)this) && this.m_6898_(itemstack)) {
            this.m_5496_(SoundEvents.f_11976_, 1.5f, 0.8f);
            if (this.m_21187_().nextInt(3) == 0) {
                this.m_21828_(player);
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123750_, 3, 6);
            } else {
                EntityUtils.spawnParticlesOnEntity(this.f_19853_, (LivingEntity)this, ParticleTypes.f_123762_, 3, 3);
            }
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, IDLE_TALK, ATTACK_SPIT};
    }

    @Override
    public Animation getAnimationEat() {
        return NO_ANIMATION;
    }

    public void performRangedAttack(LivingEntity entityIn, float p_33318_) {
        ProjectileSpit camel_spit = new ProjectileSpit(this.f_19853_, this, new MobEffectInstance(MobEffects.f_19604_, 200, 0));
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ATTACK_SPIT);
        }
        double d0 = entityIn.m_20185_() - this.m_20185_();
        double d1 = entityIn.m_20227_(0.3333333333333333) - camel_spit.m_20186_();
        double d2 = entityIn.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2) * (double)0.2f;
        camel_spit.m_6686_(d0, d1 + d3, d2, 1.5f, 10.0f);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12098_, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f);
        }
        this.f_19853_.m_7967_((Entity)camel_spit);
    }
}

